<?php require_once('setup.php'); ?>
<!doctype html>
<html lang="en">

<head>
  <!-- Required meta tags -->
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
  <title><?= $main_capital_name; ?></title>
  <link href="//fonts.googleapis.com/css2?family=Kumbh+Sans:wght@300;400;700&display=swap" rel="stylesheet">
  <!-- Template CSS -->
  <link rel="stylesheet" href="assets/css/style-starter.css">
  <link rel="icon" type="image/png" href="assets/images/logo.png" />
</head>

<body>
  <?php require_once('preloader.php'); ?>
  <!--header-->
  <?php require_once('header.php'); ?>
  <!--/header-->
  <div class="inner-banner">
  </div>
  <section class="w3l-breadcrumb">
    <div class="container">
      <ul class="breadcrumbs-custom-path">
        <li><a href="/">Home</a></li>
        <li class="active"><span class="fa fa-angle-right mx-2" aria-hidden="true"></span> About Us</li>
      </ul>
    </div>
  </section>
  <!-- home page about section -->
  <section class="w3l-index3" id="about">
    <div class="midd-w3 py-5">
      <div class="container py-lg-5 py-md-3">
        <div class="row">
          <div class="col-lg-6">
            <div class="position-relative">
              <img src="assets/images/blog2.jpg" alt="" class="radius-image img-fluid">
            </div>
          </div>
          <div class="col-lg-6 mt-lg-0 mt-md-5 mt-4 align-self">
            <?php require_once('translate.php'); ?>
            <h3 class="title-big mx-0"><?= $main_capital_name ?></h3>
            <p class="mt-md-4 mt-3">
              <?= $main_name ?> commenced operations in January 2003 following the merger of nine Banks with competences in investment, corporate and retail banking. Today, <?= $main_name ?> is one of the leading retail banks with over 44 business offices spread across the Asia, Europe and The United States Of America.
            </p>
          </div>
        </div>
      </div>
    </div>
  </section>
  <!-- //home page about section -->
  <!-- stats -->
  <section class="w3l-stats py-5" id="stats">
    <div class="gallery-inner container py-lg-5 py-md-4">
      <div class="row">
        <div class="col-lg-12 mt-lg-0 mt-md-5 mt-4 align-self">
          <p class="mt-md-4 mt-3 text-center">
            The Bank offers wide-ranging financial services to individuals, businesses and the public sector of the nation’s economy. As a further commitment to the growth of the nation’s economy, <?= $main_name ?> focuses in particular on SMEs and Agribusinesses. We are driven by the vision to be the retail bank of choice for all and this is at the core of all that we do.
          </p>
          <p class="mt-md-4 mt-3 text-center">
            Our Offices are located at ASIA,EUROPE,USA
          </p>
          <p class="mt-md-4 mt-3 text-center">
            Welcome to a bank where succeeding together is our objective.
          </p>
        </div>
      </div>
    </div>
  </section>
  <!-- //stats -->
  <!-- services section -->
  <section id="services" class="w3l-servicesblock3 py-5">
    <div class="container py-lg-5 py-md-4 py-2">
      <div class="welcome-left">
        <div class="grids-area-hny main-cont-wthree-fea row pt-4">
          <div class="col-lg-6 col-md-6 grids-feature">
            <span class="fa fa-line-chart"></span>
            <div class="area-box">
              <h4><a href="#feature" class="title-head">Our Vision</a></h4>
              <p class="my-3">To be a financially viable, independent community bank that is committed to improving the quality of life of the communities we serve.</p>
            </div>
          </div>
          <div class="col-lg-6 col-md-6 grids-feature mt-md-0 mt-4">
            <span class="fa fa-balance-scale"></span>
            <div class="area-box">
              <h4><a href="#feature" class="title-head">Our Mission</a></h4>
              <p class="my-3">To attain the highest levels of customer advocacy, be a great place to work and deliver superior and sustainable returns to our shareholders.</p>
            </div>
          </div>
        </div>
      </div>
    </div>
  </section>
  <!-- //services section -->
  <section class="w3l-index3" id="about">
    <div class="midd-w3 py-5">
      <div class="container py-lg-5 py-md-3">
        <div class="heading align-self text-center">
          <h6 class="title-small">We play by the rules</h6>
          <h3 class="title-big mb-4">CORE VALUES</h3>
        </div>
        <div class="row">
          <div class="col-lg-4">
            <div class="position-relative">
              <h4>Teamwork</h4>
              <p class="mt-md-4 mt-3">All staff within the bank work together to ensure our commitments to stakeholders are delivered</p>
            </div>
          </div>
          <div class="col-lg-4">
            <div class="position-relative">
              <h4>Passion</h4>
              <p class="mt-md-4 mt-3">We are driven by the desire to exceed the qualitative and quantitative expectations of our customers</p>
            </div>
          </div>
          <div class="col-lg-4">
            <div class="position-relative">
              <h4>Resourcefulness</h4>
              <p class="mt-md-4 mt-3">Our people are ingenious and imaginative in seeking solutions to issues</p>
            </div>
          </div>
          <div class="col-lg-4">
            <div class="position-relative">
              <h4>Integrity</h4>
              <p class="mt-md-4 mt-3">Our people are forthright in all their dealings with internal and external customers and partners</p>
            </div>
          </div>
          <div class="col-lg-4">
            <div class="position-relative">
              <h4>Dependability</h4>
              <p class="mt-md-4 mt-3">The bank's stakeholders can always count on its reliability and loyalty</p>
            </div>
          </div>
          <div class="col-lg-4">
            <div class="position-relative">
              <h4>Excellence</h4>
              <p class="mt-md-4 mt-3">We seek to create and raise standards in our dealings, exceptionally surpassing expectations</p>
            </div>
          </div>
          <div class="col-lg-4">
            <div class="position-relative">
              <h4>Empathy</h4>
              <p class="mt-md-4 mt-3"><?= $main_name ?> holds itself to the enduring principle of showing respect and compassion to all</p>
            </div>
          </div>
        </div>
      </div>
    </div>
  </section>
  <!-- footer -->
  <?php require_once('footer.php'); ?>
  <!-- //footer -->
  <!--  javascripts file here -->
  <script src="assets/js/jquery-3.3.1.min.js"></script>
  <script src="assets/js/theme-change.js"></script> <!-- //light and dark mode switch js -->
  <script src="assets/js/circles.js"></script>
  <!-- stats number counter-->
  <script src="assets/js/jquery.waypoints.min.js"></script>
  <script src="assets/js/jquery.countup.js"></script>
  <script>
    $('.counter').countUp();
  </script>
  <!-- //stats number counter -->
  <!-- owl carousel -->
  <script src="assets/js/owl.carousel.js"></script>
  <!-- script for banner slider-->
  <script>
    $(document).ready(function() {
      $('.owl-one').owlCarousel({
        loop: true,
        margin: 0,
        nav: false,
        responsiveClass: true,
        autoplay: true,
        autoplayTimeout: 5000,
        autoplaySpeed: 1000,
        autoplayHoverPause: false,
        responsive: {
          0: {
            items: 1
          },
          480: {
            items: 1
          },
          667: {
            items: 1
          },
          1000: {
            items: 1
          }
        }
      })
    })
  </script>
  <!-- //script -->
  <!-- owl carousel -->
  <!-- script for tesimonials carousel slider -->
  <script>
    $(document).ready(function() {
      $("#owl-demo2").owlCarousel({
        loop: true,
        margin: 20,
        nav: false,
        responsiveClass: true,
        responsive: {
          0: {
            items: 1,
            nav: false
          },
          1000: {
            items: 1,
            nav: false,
            loop: false
          }
        }
      })
    })
  </script>
  <!-- //script for tesimonials carousel slider -->
  <!-- disable body scroll which navbar is in active -->
  <script>
    $(function() {
      $('.navbar-toggler').click(function() {
        $('body').toggleClass('noscroll');
      })
    });
  </script>
  <!-- disable body scroll which navbar is in active -->
  <!--/MENU-JS-->
  <script>
    $(window).on("scroll", function() {
      var scroll = $(window).scrollTop();

      if (scroll >= 80) {
        $("#site-header").addClass("nav-fixed");
      } else {
        $("#site-header").removeClass("nav-fixed");
      }
    });

    //Main navigation Active Class Add Remove
    $(".navbar-toggler").on("click", function() {
      $("header").toggleClass("active");
    });
    $(document).on("ready", function() {
      if ($(window).width() > 991) {
        $("header").removeClass("active");
      }
      $(window).on("resize", function() {
        if ($(window).width() > 991) {
          $("header").removeClass("active");
        }
      });
    });
  </script>
  <!--//MENU-JS-->
  <script src="assets/js/bootstrap.min.js"></script><!-- //bootstrap js -->
  <?php include('chat.php'); ?>
</body>

</html>
