<?php include("security.php"); ?>
<?php require_once('../setup.php'); ?>
<?php define('passportPath', 'cheque/');?>
<!DOCTYPE html>
<html lang="en">

  <head>
    <!-- Required meta tags -->
    <meta charset="utf-8">
    <meta name="viewport"
      content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <title>
      <?= $main_capital_name; ?>
    </title>
    <!-- plugins:css -->
    <link rel="stylesheet" href="vendors/feather/feather.css">
    <link rel="stylesheet" href="vendors/ti-icons/css/themify-icons.css">
    <link rel="stylesheet" href="vendors/css/vendor.bundle.base.css">
    <!-- endinject -->
    <!-- Plugin css for this page -->
    <link rel="stylesheet"
      href="vendors/datatables.net-bs4/dataTables.bootstrap4.css">
    <link rel="stylesheet" href="vendors/ti-icons/css/themify-icons.css">
    <link rel="stylesheet" type="text/css" href="js/select.dataTables.min.css">
    <link rel="stylesheet" href="vendors/mdi/css/materialdesignicons.min.css">
    <!-- End plugin css for this page -->
    <!-- inject:css -->
    <link rel="stylesheet" href="css/vertical-layout-light/style.css">
    <!-- endinject -->
    <link rel="shortcut icon" href="../assets/images/logo.png" />
  </head>

  <body>
    <div class="container-scroller">
      <!-- partial:partials/_navbar.html -->
      <?php include('topbar.php'); ?>
      <!-- partial -->
      <div class="container-fluid page-body-wrapper">
        <!-- partial:partials/_sidebar.html -->
        <?php include('nav.php'); ?>
        <!-- partial -->
        <div class="main-panel">
          <div class="content-wrapper">
            <div class="row">
              <div class="col-md-6 grid-margin stretch-card">
                <div class="card">
                  <div class="card-body">
                    <h4 class="card-title">Deposit a New Cheque</h4>
                    <p class="card-description">
                      Please, carefully fill required details below to deposit your cheque, and we would get back to you within 24 hours working day.
                    </p>
                    <?php
                    if (isset($_POST['deposit'])) {

                      require_once("conn.php");
                      $user_id = $dbid;
                      $full_name = mysqli_real_escape_string($dbconfig, $_POST['full_name']);
                      $amount_on_cheque = mysqli_real_escape_string($dbconfig, $_POST['amount_on_cheque']);
                      $cheque_number = mysqli_real_escape_string($dbconfig, $_POST['cheque_number']);

                      //Cheque upload query
                      $target_dir = "cheque/";
                      $upload_cheque = mysqli_real_escape_string($dbconfig, $_FILES['upload_cheque']['name']);
                      $target_file = $target_dir . basename($_FILES["upload_cheque"]["name"]);
                      $uploadOk = 1;
                      $imageFileType = pathinfo($target_file, PATHINFO_EXTENSION);
                      $check = @getimagesize($_FILES["upload_cheque"]["tmp_name"]);
                      $pass = 1;

                      // Check if image file is a actual image or fake image
                      if ($check == false) {
                        echo '<div class="alert alert-danger" role="alert">
                        <button type="button" class="close" data-dismiss="alert"><span aria-hidden="true"></span><span class="sr-only">Close</span></button>
                         &nbsp; Cheque is not an image. <b>Upload an image!</b>
                      </div>';
                        $uploadOk = 0;
                      }

                      // Check if file already exists
                      if (file_exists($target_file)) {
                        echo '<div class="alert alert-danger" role="alert">
                        <button type="button" class="close" data-dismiss="alert"><span aria-hidden="true"></span><span class="sr-only">Close</span></button>
                         &nbsp; Cheque name already exists. <b>Rename your cheque file!</b>
                      </div>';
                        $uploadOk = 0;
                      }

                      // Check file size
                      if ($_FILES["upload_cheque"]["size"] > 5000000) {
                        echo '<div class="alert alert-danger" role="alert">
                        <button type="button" class="close" data-dismiss="alert"><span aria-hidden="true"></span><span class="sr-only">Close</span></button>
                         &nbsp; Cheque most be less than 5MB. <b>Resize your Cheque!</b>
                      </div>';
                        $uploadOk = 0;
                      }

                      // Allow certain file formats
                      if ($imageFileType != "jpg" && $imageFileType != "png" && $imageFileType != "jpeg" && $imageFileType != "JPG" && $imageFileType != "PNG" && $imageFileType != "JPEG") {
                        echo '<div class="alert alert-danger" role="alert">
                        <button type="button" class="close" data-dismiss="alert"><span aria-hidden="true"></span><span class="sr-only">Close</span></button>
                         &nbsp; Only JPG, JPEG & PNG Allowed. <b>Change cheque format!</b>
                      </div>';
                        $uploadOk = 0;
                      }

                      // Check if $uploadOk is set to 0 by an error
                      if ($uploadOk == 0) {
                        echo '<div class="alert alert-danger" role="alert">
                        <button type="button" class="close" data-dismiss="alert"><span aria-hidden="true"></span><span class="sr-only">Close</span></button>
                         &nbsp; Your cheque was not uploaded. <b>Please try again later!</b>
                      </div>';
                      } else {
                        if ($pass == 1) {
                          //If no error proceed to uploading cheque
                          if (move_uploaded_file($_FILES["upload_cheque"]["tmp_name"], $target_file)) {
                            $sql = "INSERT INTO cheques (user_id, full_name, amount_on_cheque, cheque_number, upload_cheque) VALUES ('$user_id', '$full_name', '$amount_on_cheque', '$cheque_number', '$upload_cheque')";
                            if ($dbconfig->query($sql) === true) {
                              header("Refresh: 5; url=view-cheque");
                              echo '
                                <div class="alert alert-success" role="alert">
                                <button type="button" class="close" data-dismiss="alert"><span aria-hidden="true"></span><span class="sr-only">Close</span></button>
                                &nbsp; Your Cheque Was Uploaded Successfully. <b>Kindly hold for redirection!</b>
                              </div>
                              ';
                            }
                          } else {
                            echo
                              '<div class="alert alert-danger" role="alert">
                            <button type="button" class="close" data-dismiss="alert"><span aria-hidden="true"></span><span class="sr-only">Close</span></button>
                             &nbsp; There was an error uploading your cheque. <b>Please try again later!</b>
                          </div>';
                          }
                        }
                      }
                    }
                    ?>
                    <form class="forms-sample" action="" method="POST" enctype="multipart/form-data">
                      <div class="form-group">
                        <label for="exampleInputUsername1">Full Name<sup
                            style="color: red;">*</sup></label>
                        <input style="text-transform: capitalize;" type="text"
                          class="form-control" id="exampleInputUsername1" placeholder="Full Name - as appeared on cheque..."
                          value="<?php if (isset($_POST['full_name'])) {
                            echo $_POST['full_name'];
                          } ?>" name="full_name" required>
                      </div>
                      <div class="form-group">
                        <label for="exampleInputUsername1">Amount on Cheque<sup
                            style="color: red;">*</sup></label>
                        <input type="number" class="form-control" id="exampleInputUsername1"
                          value="<?php if (isset($_POST['amount_on_cheque'])) {
                            echo $_POST['amount_on_cheque'];
                          } ?>" name="amount_on_cheque" placeholder=" eg. 10,000.00" required>
                      </div>
                      <div class="form-group">
                        <label for="exampleInputUsername1">Cheque Number<sup
                            style="color: red;">*</sup></label>
                        <input type="number" class="form-control" id="exampleInputUsername1"
                          value="<?php if (isset($_POST['cheque_number'])) {
                            echo $_POST['cheque_number'];
                          } ?>" name="cheque_number" placeholder="********" required>
                      </div>
                      <div class="form-group">
                        <label for="exampleInputUsername1">Upload Cheque<sup
                            style="color: red;">*</sup></label>
                        <input type="file" class="form-control"
                          id="exampleInputUsername1" name="upload_cheque" required>
                      </div>
                      <button type="submit" class="btn btn-primary mr-2"
                        name="deposit">Deposit Cheque Now</button>
                      <a href="dashboard" class="btn btn-light">Cancel</a>
                    </form>
                  </div>
                </div>
              </div>
            </div>
          </div>
          <!-- content-wrapper ends -->
          <!-- partial:partials/_footer.html -->
          <footer class="footer">
            <?php
            include('footer.php');
            ?>
          </footer>
          <!-- partial -->
        </div>
        <!-- main-panel ends -->
      </div>
      <!-- page-body-wrapper ends -->
    </div>
    <!-- container-scroller -->

    <!-- plugins:js -->
    <script src="vendors/js/vendor.bundle.base.js"></script>
    <!-- endinject -->
    <!-- Plugin js for this page -->
    <script src="vendors/chart.js/Chart.min.js"></script>
    <script src="vendors/datatables.net/jquery.dataTables.js"></script>
    <script src="vendors/datatables.net-bs4/dataTables.bootstrap4.js"></script>
    <script src="js/dataTables.select.min.js"></script>

    <!-- End plugin js for this page -->
    <!-- inject:js -->
    <script src="js/off-canvas.js"></script>
    <script src="js/hoverable-collapse.js"></script>
    <script src="js/template.js"></script>
    <script src="js/settings.js"></script>
    <script src="js/todolist.js"></script>
    <!-- endinject -->
    <!-- Custom js for this page-->
    <script src="js/dashboard.js"></script>
    <script src="js/Chart.roundedBarCharts.js"></script>
    <!-- End custom js for this page-->
    <?php include('../chat.php'); ?>
  </body>

</html>
