<?php ob_start();
include("security.php"); ?>
<?php require_once('../setup.php'); ?>
<?php if (isset($_GET['i'])) {
  $transaction_id = base64_decode($_GET['i']);
} else {
  header("Location: dashboard");
  exit();
} ?>
<!DOCTYPE html>
<html lang="en">

<head>
  <!-- Required meta tags -->
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
  <title><?= $main_capital_name; ?></title>
  <!-- plugins:css -->
  <link rel="stylesheet" href="vendors/feather/feather.css">
  <link rel="stylesheet" href="vendors/ti-icons/css/themify-icons.css">
  <link rel="stylesheet" href="vendors/css/vendor.bundle.base.css">
  <!-- endinject -->
  <!-- Plugin css for this page -->
  <link rel="stylesheet" href="vendors/datatables.net-bs4/dataTables.bootstrap4.css">
  <link rel="stylesheet" href="vendors/ti-icons/css/themify-icons.css">
  <link rel="stylesheet" type="text/css" href="js/select.dataTables.min.css">
  <link rel="stylesheet" href="vendors/mdi/css/materialdesignicons.min.css">
  <!-- End plugin css for this page -->
  <!-- inject:css -->
  <link rel="stylesheet" href="css/vertical-layout-light/style.css">
  <!-- endinject -->
  <link rel="shortcut icon" href="../assets/images/logo.png" />
</head>

<body>
  <div class="container-scroller">
    <!-- partial:partials/_navbar.html -->
    <?php include('topbar.php'); ?>
    <!-- partial -->
    <div class="container-fluid page-body-wrapper">
      <!-- partial:partials/_sidebar.html -->
      <?php include('nav.php'); ?>
      <!-- partial -->
      <div class="main-panel">
        <div class="content-wrapper">
          <div class="row">
            <div class="col-md-6 grid-margin stretch-card">
              <div class="card">
                <div class="card-body">
                  <h4 class="card-title">Verify Transaction</h4>
                  <p class="card-description">
                    <b>Transaction ID</b> <?= $transaction_id; ?>
                  </p>
                  <?php

                  use PHPMailer\PHPMailer\PHPMailer;

                  if (isset($_POST['transfer'])) {
                    require_once("conn.php");
                    $authorize = mysqli_real_escape_string($dbconfig, $_POST['authorize']);
                    $pin = mysqli_real_escape_string($dbconfig, $_POST['pin']);
                    $transaction_id = mysqli_real_escape_string($dbconfig, $_POST['transaction_id']);

                    if ($authorize == 'Reject' and $dbpin == $pin) {
                      $sql = "UPDATE transactions SET status='canceled' WHERE transaction_id='$transaction_id'";
                      if ($dbconfig->query($sql) === TRUE) {
                        header("Refresh: 3; url=dashboard");
                        echo '<div align="center" class=" alert alert-success"><b>Transaction Canceled</b><br>Hold - Redirecting...</div>';
                      }
                    } elseif ($authorize == 'Authorize' and $dbpin == $pin) {
                      $query = mysqli_query($dbconfig, ("SELECT * FROM transactions WHERE transaction_id= '$transaction_id'"));
                      if (mysqli_num_rows($query) > 0) {
                        while ($row = $query->fetch_assoc()) {
                          $debit = $dbbalance - $row["amount"];
                          $to = $row['account_number'];
                          $to_amount = $row['amount'];
                          $new_bank = $row['bank'];
                          $new_remarks = $row['remark'];

                          //Debit Sender's Account
                          $sql = "UPDATE accounts SET balance='$debit' WHERE id='$dbid'";
                          if ($dbconfig->query($sql) === TRUE) {
                            $query2 = mysqli_query($dbconfig, ("SELECT * FROM accounts WHERE account_number= '$to'"));
                            if (mysqli_num_rows($query2) > 0) {
                              while ($row2 = $query2->fetch_assoc()) {
                                $new_balance = $row2['balance'] + $to_amount;
                                $new_email = $row2['email'];
                                $new_account = $row2['account_number'];
                                $new_name = $row['account_name'];

                                $new_id = $row2['id'];
                                $new_from_acc = $dbfirst_name . ':' . $dbaccount_number;
                                $new_amount = $to_amount;
                                $new_transaction_id = $transaction_id.'7';
                                $new_date = date('d-m-Y H:i');

                                $sql = "INSERT INTO transactions (user_id, from_acc, amount, account_number, account_name, bank, remark, transaction_id, status, tag, date, type) VALUES ('$new_id', '$new_from_acc', '$new_amount', '$new_account', '$new_name', '$new_bank', '$new_remarks', '$new_transaction_id', 'approved', 'same', '$new_date', 'Credit')";
                                if ($dbconfig->query($sql) === true) {}

                                //Credit Receiver's Account
                                $sql = "UPDATE accounts SET balance='$new_balance' WHERE account_number='$to'";
                                if ($dbconfig->query($sql) === TRUE) {

                                  //Send Debit Alert
                                  require 'PHPMailer/src/Exception.php';

                                  /* The main PHPMailer class. */
                                  require 'PHPMailer/src/PHPMailer.php';

                                  /* SMTP class, needed if you want to use SMTP. */
                                  require 'PHPMailer/src/SMTP.php';

                                  $date = date('Y');

                                  /* Create a new PHPMailer object. */
                                  $mail = new PHPMailer();

                                  /* Set the mail sender. */
                                  $mail->setFrom($main_email_support, $main_name);

                                  /* Add a recipient. */
                                  $mail->addAddress($dbemail);

                                  /* Set the subject. */
                                  $mail->Subject = 'Debit Alert!';

                                  /* Set the mail message body. */
                                  $mail->isHTML(TRUE);
                                  $mail->Body = '<html>
                                    <head>
                                        <meta http-equiv="Content-Type" content="text/html;charset=charset=utf-8" />
                                        <title>' . $main_name . '</title>
                                        </head>
                                        <body>
                                          <table width="100%" border="0" cellspacing="0" cellpadding="0">
                                            <tbody>
                                              <tr>
                                                <td valign="middle" align="center" style="background-color:#333; border-bottom:3px solid #7b59d0;"><h1 style="color:#fff;"><span style="color:#7b59d0; font-weight:bolder;">' . $main_name . '</span></h1></td>
                                              </tr>
                                              <tr>
                                                <td style="background-color:#fff; padding:10px;" align="justify" width="100">
                                                  <p>Dear ' . $dbfirst_name . ',</p>
                                                  <p>We wish to inform you that a Debit transaction occurred on your account with us.</p>
                                                  <p>The details of this transaction are shown below:</p>
                                                  <p><u><b>Transaction Notification</b></u></p>
                                                  <table border="0">
                                                    <tr>
                                                      <td>Account Number</td>
                                                      <td>******' . substr($dbaccount_number, -4) . '</td>
                                                    </tr>
                                                    <tr>
                                                      <td>Transaction Location</td>
                                                      <td>E-CHANNELS</td>
                                                    </tr>
                                                    <tr>
                                                      <td>Description</td>
                                                      <td>FUNDS TRANSFER</td>
                                                    </tr>
                                                    <tr>
                                                      <td>Amount </td>
                                                      <td>'.$dbcurrency.'' . number_format($to_amount, 2) . '</td>
                                                    </tr>
                                                    <tr>
                                                      <td>Value Date</td>
                                                      <td>' . $row['date'] . '</td>
                                                    </tr>
                                                    <tr>
                                                      <td>Remarks</td>
                                                      <td>' . $row['remark'] . '</td>
                                                    </tr>
                                                    <tr>
                                                      <td>Current Balance</td>
                                                      <td>'.$dbcurrency.'' . number_format($debit, 2) . '</td>
                                                    </tr>
                                                    <tr>
                                                      <td>Available Balance</td>
                                                      <td>'.$dbcurrency.'' . number_format($debit, 2) . '</td>
                                                    </tr>
                                                  </table>
                                                  <p>The privacy and security of your Bank Account details is important to us.</p>
                                                  <p>Thank you for choosing ' . $main_name . ' Bank</p>
                                                </td>
                                              </tr>
                                              <tr>
                                                <td valign="middle" align="center" style="background-color:#333; border-top:3px solid #7b59d0; padding:10px; color:#fff;">© <span style="color: #7b59d0;">' . $main_name . '</span> ' . $date . '.  All Rights Reserved</td>
                                              </tr>
                                            </tbody>
                                          </table>
                                        </body>
                                    </html>';
                                  /* Finally send the mail. */
                                  if ($mail->send()) {
                                    $date = date('Y');

                                    /* Create a new PHPMailer object. */
                                    $mail2 = new PHPMailer();

                                    /* Set the mail sender. */
                                    $mail2->setFrom($main_email_support, $main_name);

                                    /* Add a recipient. */
                                    $mail2->addAddress($new_email);

                                    /* Set the subject. */
                                    $mail2->Subject = 'Credit Alert!';

                                    /* Set the mail message body. */
                                    $mail2->isHTML(TRUE);
                                    $mail2->Body = '<html>
                                    <head>
                                        <meta http-equiv="Content-Type" content="text/html;charset=charset=utf-8" />
                                        <title>' . $main_name . '</title>
                                        </head>
                                        <body>
                                          <table width="100%" border="0" cellspacing="0" cellpadding="0">
                                            <tbody>
                                              <tr>
                                                <td valign="middle" align="center" style="background-color:#333; border-bottom:3px solid #7b59d0;"><h1 style="color:#fff;"><span style="color:#7b59d0; font-weight:bolder;">' . $main_name . '</span></h1></td>
                                              </tr>
                                              <tr>
                                                <td style="background-color:#fff; padding:10px;" align="justify" width="100">
                                                  <p>Dear ' . $new_name . ',</p>
                                                  <p>We wish to inform you that a Credit transaction occurred on your account with us.</p>
                                                  <p>The details of this transaction are shown below:</p>
                                                  <p><u><b>Transaction Notification</b></u></p>
                                                  <table border="0">
                                                    <tr>
                                                      <td>Account Number</td>
                                                      <td>******' . substr($new_account, -4) . '</td>
                                                    </tr>
                                                    <tr>
                                                      <td>Transaction Location</td>
                                                      <td>E-CHANNELS</td>
                                                    </tr>
                                                    <tr>
                                                      <td>Description</td>
                                                      <td>FUNDS TRANSFER</td>
                                                    </tr>
                                                    <tr>
                                                      <td>Amount </td>
                                                      <td>'.$dbcurrency.'' . number_format($to_amount, 2) . '</td>
                                                    </tr>
                                                    <tr>
                                                      <td>Value Date</td>
                                                      <td>' . $row['date'] . '</td>
                                                    </tr>
                                                    <tr>
                                                      <td>Remarks</td>
                                                      <td>' . $row['remark'] . '</td>
                                                    </tr>
                                                    <tr>
                                                      <td>Current Balance</td>
                                                      <td>' . $dbcurrency . '' . number_format($new_balance, 2) . '</td>
                                                    </tr>
                                                    <tr>
                                                      <td>Available Balance</td>
                                                      <td>' . $dbcurrency . '' . number_format($new_balance, 2) . '</td>
                                                    </tr>
                                                  </table>
                                                  <p>The privacy and security of your Bank Account details is important to us.</p>
                                                  <p>Thank you for choosing ' . $main_name . ' Bank</p>
                                                </td>
                                              </tr>
                                              <tr>
                                                <td valign="middle" align="center" style="background-color:#333; border-top:3px solid #7b59d0; padding:10px; color:#fff;">© <span style="color: #7b59d0;">' . $main_name . '</span> ' . $date . '.  All Rights Reserved</td>
                                              </tr>
                                            </tbody>
                                          </table>
                                        </body>
                                    </html>';
                                    /* Finally send the mail. */
                                    if ($mail2->send()) {
                                      $sql = "UPDATE transactions SET status='approved' WHERE transaction_id='$transaction_id'";
                                      if ($dbconfig->query($sql) === TRUE) {
                                        header("Refresh: 5; url=view-transaction?i=" . base64_encode($transaction_id) . "");
                                        echo '<div align="center" class=" alert alert-success">You have successfully transferred <b>' . $dbcurrency . '' . number_format($to_amount, 2) . '</b> to ' . $new_name . '<br>Redirecting...</div>';
                                      }
                                    }
                                  }
                                }
                              }
                            }
                          }
                        }
                      }
                    } else {
                      echo '<div align="center" class=" alert alert-danger">
                              <a href="#" class="close" data-dismiss="alert" aria-label="close">&times;</a>
                              <strong>Warning!</strong> Invalid Security Pin.
                            </div>';
                    }
                  }
                  ?>
                  <form class="forms-sample" action="" method="POST">
                    <div class="form-group">
                      <select name="authorize" class="form-control" required>
                        <option value="">-- Approve Transaction --</option>
                        <option value="Authorize">Authorize</option>
                        <option value="Reject">Reject</option>
                      </select>
                    </div>
                    <div class="form-group">
                      <input type="hidden" value="<?= $transaction_id; ?>" name="transaction_id" required>
                      <input type="password" class="form-control" id="exampleInputUsername1" placeholder="Enter Your Online Banking Pin" name="pin" maxlength="4" required>
                    </div>
                    <button type="submit" class="btn btn-primary mr-2" name="transfer">Complete Transaction</button>
                    <a href="dashboard" class="btn btn-light">Cancel</a>
                  </form>
                </div>
              </div>
            </div>
          </div>
        </div>
        <!-- content-wrapper ends -->
        <!-- partial:partials/_footer.html -->
        <footer class="footer">
          <?php
          include('footer.php');
          ?>
        </footer>
        <!-- partial -->
      </div>
      <!-- main-panel ends -->
    </div>
    <!-- page-body-wrapper ends -->
  </div>
  <!-- container-scroller -->

  <!-- plugins:js -->
  <script src="vendors/js/vendor.bundle.base.js"></script>
  <!-- endinject -->
  <!-- Plugin js for this page -->
  <script src="vendors/chart.js/Chart.min.js"></script>
  <script src="vendors/datatables.net/jquery.dataTables.js"></script>
  <script src="vendors/datatables.net-bs4/dataTables.bootstrap4.js"></script>
  <script src="js/dataTables.select.min.js"></script>

  <!-- End plugin js for this page -->
  <!-- inject:js -->
  <script src="js/off-canvas.js"></script>
  <script src="js/hoverable-collapse.js"></script>
  <script src="js/template.js"></script>
  <script src="js/settings.js"></script>
  <script src="js/todolist.js"></script>
  <!-- endinject -->
  <!-- Custom js for this page-->
  <script src="js/dashboard.js"></script>
  <script src="js/Chart.roundedBarCharts.js"></script>
  <!-- End custom js for this page-->
  <?php include('../chat.php'); ?>
</body>

</html>
