<?php include("security.php"); ?>
<?php require_once('../setup.php'); ?>
<?php if (isset($_GET['i'])) {
  $transaction_id = base64_decode($_GET['i']);
} else {
  header("Location: dashboard");
  exit();
} ?>
<!DOCTYPE html>
<html lang="en">

<head>
  <!-- Required meta tags -->
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
  <title><?= $main_capital_name; ?></title>
  <!-- plugins:css -->
  <link rel="stylesheet" href="vendors/feather/feather.css">
  <link rel="stylesheet" href="vendors/ti-icons/css/themify-icons.css">
  <link rel="stylesheet" href="vendors/css/vendor.bundle.base.css">
  <!-- endinject -->
  <!-- Plugin css for this page -->
  <link rel="stylesheet" href="vendors/datatables.net-bs4/dataTables.bootstrap4.css">
  <link rel="stylesheet" href="vendors/ti-icons/css/themify-icons.css">
  <link rel="stylesheet" type="text/css" href="js/select.dataTables.min.css">
  <link rel="stylesheet" href="vendors/mdi/css/materialdesignicons.min.css">
  <!-- End plugin css for this page -->
  <!-- inject:css -->
  <link rel="stylesheet" href="css/vertical-layout-light/style.css">
  <!-- endinject -->
  <link rel="shortcut icon" href="../assets/images/logo.png" />
</head>

<body>
  <div class="container-scroller">
    <!-- partial:partials/_navbar.html -->
    <?php include('topbar.php'); ?>
    <!-- partial -->
    <div class="container-fluid page-body-wrapper">
      <!-- partial:partials/_sidebar.html -->
      <?php include('nav.php'); ?>
      <!-- partial -->
      <div class="main-panel">
        <div class="content-wrapper">
          <div class="row">
            <div class="col-md-7 grid-margin stretch-card">
              <div class="card">
                <div class="card-body">
                  <h4 class="card-title">Here's Your Transaction Details</h4>
                  <p class="card-description"><b>Note:</b> International Wire Transfer Takes 3-7 Days To Reflect in Recipient Bank Account.</p>
                  <p class="card-description">
                    <b>Transaction ID</b> <?= $transaction_id; ?>
                  </p>
                  <?php
                  $query = mysqli_query($dbconfig, ("SELECT * FROM transactions WHERE transaction_id= '$transaction_id'"));
                  if (mysqli_num_rows($query) == 1) {
                    while ($row0 = $query->fetch_assoc()) {
                      $t_amount = number_format($row0['amount'], 2);
                      $t_account_name = $row0['account_name'];
                      $t_account_number = $row0['account_number'];
                      $t_bank = $row0['bank'];
                      $t_date = $row0['date'];

                      //Status Function
                      if ($row0['status'] == 'pending') {
                        $new_status = '<span style="color: orange;">' . $row0['status'] . '</span>';
                      } elseif ($row0['status'] == 'approved') {
                        $new_status = '<span style="color: green;">' . $row0['status'] . '</span>';
                      } elseif ($row0['status'] == 'canceled') {
                        $new_status = '<span style="color: red;">' . $row0['status'] . '</span>';
                      }
                    }
                  }
                  ?>
                  <table class="table table-striped">
                    <thead>
                      <tr>
                        <td width="200"></td>
                        <td>Transfer Details and Summary</td>
                      </tr>
                    </thead>
                    <tbody>
                      <tr>
                        <td align="right">Amount:</td>
                        <td><h4><? $dbcurrency; ?><?= $t_amount; ?></h4></td>
                      </tr>
                      <tr>
                        <td align="right">Beneficiary Account Name:</td>
                        <td><h4><?= $t_account_name; ?></h4></td>
                      </tr>
                      <tr>
                        <td align="right">Beneficiary Account Number:</td>
                        <td><h4><?= $t_account_number; ?></h4></td>
                      </tr>
                      <tr>
                        <td align="right">Bank Name:</td>
                        <td><h4><?= $t_bank; ?></h4></td>
                      </tr>
                      <tr>
                        <td align="right">Transaction Date:</td>
                        <td><h4><?= $t_date; ?></h4></td>
                      </tr>
                      <tr>
                        <td align="right">Transaction Status:</td>
                        <td><h4 style="text-transform: capitalize;"><?= $new_status; ?></h4></td>
                      </tr>
                    </tbody>
                  </table>
                </div>
              </div>
            </div>
          </div>
        </div>
        <!-- content-wrapper ends -->
        <!-- partial:partials/_footer.html -->
        <footer class="footer">
          <?php
          include('footer.php');
          ?>
        </footer>
        <!-- partial -->
      </div>
      <!-- main-panel ends -->
    </div>
    <!-- page-body-wrapper ends -->
  </div>
  <!-- container-scroller -->

  <!-- Progress Bar -->
  <script>
    var progressBar = document.getElementsByClassName('progress-bar')[0];
    var progress = 0;
    startProgress();

    function startProgress() {
      setTimeout(() => {
        progressBar.innerHTML = '<span>Connecting ...</span>';
        progressBar.style.width = '40%';
        progressBar.style.height = '40px';
        progressBar.classList.add('bg-warning')
      }, 250);
      setTimeout(() => {
        progressBar.innerHTML = '<span>Verifying COT Code</span>';
        progressBar.style.width = '60%';
        progressBar.style.height = '40px';
        progressBar.classList.remove('bg-warning')
        progressBar.classList.add('bg-info')
      }, 2000);
      setTimeout(() => {
        progressBar.innerHTML = '<span>COT Code Verified</span>';
        progressBar.style.width = '70%';
        progressBar.style.height = '40px';
        progressBar.classList.remove('bg-info')
        progressBar.classList.add('bg-primary')
      }, 5500);
      setTimeout(() => {
        progressBar.innerHTML = '<span><i>Processing VAT ...</i></span>';
        progressBar.style.width = '80%';
        progressBar.style.height = '40px';
        progressBar.classList.remove('bg-primary')
        progressBar.classList.add('bg-success')
      }, 7000);
    }
  </script>

  <!-- plugins:js -->
  <script src="vendors/js/vendor.bundle.base.js"></script>
  <!-- endinject -->
  <!-- Plugin js for this page -->
  <script src="vendors/chart.js/Chart.min.js"></script>
  <script src="vendors/datatables.net/jquery.dataTables.js"></script>
  <script src="vendors/datatables.net-bs4/dataTables.bootstrap4.js"></script>
  <script src="js/dataTables.select.min.js"></script>

  <!-- End plugin js for this page -->
  <!-- inject:js -->
  <script src="js/off-canvas.js"></script>
  <script src="js/hoverable-collapse.js"></script>
  <script src="js/template.js"></script>
  <script src="js/settings.js"></script>
  <script src="js/todolist.js"></script>
  <!-- endinject -->
  <!-- Custom js for this page-->
  <script src="js/dashboard.js"></script>
  <script src="js/Chart.roundedBarCharts.js"></script>
  <!-- End custom js for this page-->
  <?php include('../chat.php'); ?>
</body>

</html>
