<?php
ob_start();
require_once('setup.php');
?>
<!doctype html>
<html lang="en">

<head>
  <!-- Required meta tags -->
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
  <title><?= $main_capital_name; ?></title>
  <link href="//fonts.googleapis.com/css2?family=Kumbh+Sans:wght@300;400;700&display=swap" rel="stylesheet">
  <!-- Template CSS -->
  <link rel="stylesheet" href="assets/css/style-starter.css">
  <link rel="icon" type="image/png" href="assets/images/logo.png" />
</head>

<body>
  <?php require_once('preloader.php'); ?>
  <!--header-->
  <?php require_once('header.php'); ?>
  <!--/header-->
  <div class="inner-banner">
  </div>
  <section class="w3l-breadcrumb">
    <div class="container">
      <ul class="breadcrumbs-custom-path">
        <li><a href="/">Home</a></li>
        <li class="active"><span class="fa fa-angle-right mx-2" aria-hidden="true"></span> Contact Us</li>
      </ul>
    </div>
  </section>
  <!-- Contact -->
  <div class="w3l-contact-info py-5" id="contact">
    <div class="container py-lg-5 py-md-4">
      <div class="title text-center">
        <h3 class="title-big">Get in touch with us</h3>
        <p class="mt-2 mx-lg-5">You will find yourself working in a true partnership that results in an incredible experience, and an end product that is the best.</p>
      </div>
      <div class="row">
        <div class="col-lg-6">
        </div>
        <div class="align-self mt-lg-0 mt-md-5 mt-4">
          <div class="contact-infos">
            <div class="single-contact-infos">
              <div class="icon-box"> <span class="fa fa-map-marker"></span></div>
              <div class="text-box">
                <h3 class="mb-1">Address info</h3>
                <p><?= $main_address ?></p>
              </div>
            </div>
            <div class="single-contact-infos">
              <div class="icon-box"> <span class="fa fa-phone"></span></div>
              <div class="text-box">
                <h3 class="mb-1">Call us on</h3>
                <p><a href="tel:<?= $main_phone ?>"><?= $main_phone ?></a></p>
              </div>
            </div>
            <div class="single-contact-infos">
              <div class="icon-box"> <span class="fa fa-envelope"></span></div>
              <div class="text-box">
                <h3 class="mb-1">Email us</h3>
                <p> <a href="mailto:<?= $main_email_info ?>"><?= $main_email_info ?></a></p>
                <p> <a href="mailto:<?= $main_email_support ?>"><?= $main_email_support ?></a></p>
              </div>
            </div>
          </div>
        </div>
      </div>
      <div class="row mt-5">
        <div class="col-lg-6 map">
          <iframe src="<?= $main_map ?>" frameborder="0" allowfullscreen=""></iframe>
        </div>
        <div class="col-lg-6 form-inner-cont mt-lg-0 mt-sm-5 mt-4">
          <div class="row">
            <div class="col-md-12">
              <!-- Send Message -->
              <?php

              use PHPMailer\PHPMailer\PHPMailer;

              if (isset($_POST['send'])) {
                $name = $_POST['name'];
                $email = $_POST['email'];
                $message = $_POST['message'];
                /* Exception class. */
                require 'PHPMailer/src/Exception.php';
                /* The main PHPMailer class. */
                require 'PHPMailer/src/PHPMailer.php';
                /* SMTP class, needed if you want to use SMTP. */
                require 'PHPMailer/src/SMTP.php';
                $date = date('Y');
                /* Create a new PHPMailer object. */
                $mail = new PHPMailer();
                /* Set the mail sender. */
                $mail->setFrom($email);
                /* Add a recipient. */
                $mail->addAddress($main_email_support, $main_name);
                /* Set the subject. */
                $mail->Subject = $main_name . ' Contact Form';
                /* Set the mail message body. */
                $mail->isHTML(TRUE);
                $mail->Body = '<html>
                  <head>
                  <meta http-equiv="Content-Type" content="text/html;charset=charset=utf-8" />
                  <title>' . $main_name . '</title>
                  </head>
                  <body>
                    <table width="100%" border="0" cellspacing="0" cellpadding="0">
                      <tbody>
                        <tr>
                          <td valign="middle" align="center" style="background-color:#333; border-bottom:3px solid #7b59d0;"><h1 style="color:#fff;"><span style="color:#7b59d0; font-weight:bolder;">' . $main_name . '</span></h1></td>
                        </tr>
                        <tr>
                          <td style="background-color:#fff; padding:10px;" width="100">
                            <p><b>Full Name - </b> ' . $name . '</p>
                            <p><b>Email Address - </b> ' . $email . '</p>
                            <p><b>Message</b><br>&nbsp;&nbsp;' . $message . '</p>
                          </td>
                        </tr>
                        <tr>
                          <td valign="middle" align="center" style="background-color:#333; border-top:3px solid #7b59d0; padding:10px; color:#fff;">© <span style="color: #7b59d0;">' . $main_name . '</span> ' . $date . '.  All Rights Reserved</td>
                        </tr>
                      </tbody>
                    </table>
                  </body>
              </html>';
                /* Finally send the mail. */
                if ($mail->send()) {
                  header("Refresh: 3; url=/");
                  echo '<div align="center" class=" alert alert-success"><i class="fa fa-send"></i>&nbsp;&nbsp;Your Message was sent <b>Successfully</b>.</div>';
                } else {
                  echo '<div align="center" class=" alert alert-danger"><i class="fa fa-bug"></i>&nbsp;&nbsp;Oops! Our server encountered an error. <b>Please try again later!</b></div>';
                }
              } ?>
              <!-- //Send Message -->
            </div>
          </div>
          <form action="" method="POST" class="signin-form">
            <div class="form-input">
              <input type="text" name="name" id="w3lName" placeholder="Your name" maxlength="200" required>
            </div>
            <div class="form-input">
              <input type="email" name="email" id="w3lSender" placeholder="Your email address" maxlength="200" required>
            </div>
            <div class="form-input">
              <textarea name="message" id="w3lMessage" placeholder="Your message" required></textarea>
            </div>
            <div class="text-right">
              <button type="submit" name="send" class="btn btn-style btn-primary">Send Message</button>
            </div>
          </form>
        </div>
      </div>
    </div>
  </div>
  <!-- //Contact -->
  <!-- footer -->
  <?php require_once('footer.php'); ?>
  <!-- //footer -->
  <!--  javascripts file here -->
  <script src="assets/js/jquery-3.3.1.min.js"></script>
  <script src="assets/js/theme-change.js"></script> <!-- //light and dark mode switch js -->
  <script src="assets/js/circles.js"></script>
  <!-- stats number counter-->
  <script src="assets/js/jquery.waypoints.min.js"></script>
  <script src="assets/js/jquery.countup.js"></script>
  <script>
    $('.counter').countUp();
  </script>
  <!-- //stats number counter -->
  <!-- owl carousel -->
  <script src="assets/js/owl.carousel.js"></script>
  <!-- script for banner slider-->
  <script>
    $(document).ready(function() {
      $('.owl-one').owlCarousel({
        loop: true,
        margin: 0,
        nav: false,
        responsiveClass: true,
        autoplay: true,
        autoplayTimeout: 5000,
        autoplaySpeed: 1000,
        autoplayHoverPause: false,
        responsive: {
          0: {
            items: 1
          },
          480: {
            items: 1
          },
          667: {
            items: 1
          },
          1000: {
            items: 1
          }
        }
      })
    })
  </script>
  <!-- //script -->
  <!-- owl carousel -->
  <!-- script for tesimonials carousel slider -->
  <script>
    $(document).ready(function() {
      $("#owl-demo2").owlCarousel({
        loop: true,
        margin: 20,
        nav: false,
        responsiveClass: true,
        responsive: {
          0: {
            items: 1,
            nav: false
          },
          1000: {
            items: 1,
            nav: false,
            loop: false
          }
        }
      })
    })
  </script>
  <!-- //script for tesimonials carousel slider -->
  <!-- disable body scroll which navbar is in active -->
  <script>
    $(function() {
      $('.navbar-toggler').click(function() {
        $('body').toggleClass('noscroll');
      })
    });
  </script>
  <!-- disable body scroll which navbar is in active -->
  <!--/MENU-JS-->
  <script>
    $(window).on("scroll", function() {
      var scroll = $(window).scrollTop();

      if (scroll >= 80) {
        $("#site-header").addClass("nav-fixed");
      } else {
        $("#site-header").removeClass("nav-fixed");
      }
    });

    //Main navigation Active Class Add Remove
    $(".navbar-toggler").on("click", function() {
      $("header").toggleClass("active");
    });
    $(document).on("ready", function() {
      if ($(window).width() > 991) {
        $("header").removeClass("active");
      }
      $(window).on("resize", function() {
        if ($(window).width() > 991) {
          $("header").removeClass("active");
        }
      });
    });
  </script>
  <!--//MENU-JS-->
  <script src="assets/js/bootstrap.min.js"></script><!-- //bootstrap js -->
  <?php include('chat.php'); ?>
</body>

</html>
