<?php require_once('setup.php'); ?>
<!doctype html>
<html lang="en">

<head>
  <!-- Required meta tags -->
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
  <title><?= $main_capital_name; ?></title>
  <link href="//fonts.googleapis.com/css2?family=Kumbh+Sans:wght@300;400;700&display=swap" rel="stylesheet">
  <!-- Template CSS -->
  <link rel="stylesheet" href="assets/css/style-starter.css">
  <link rel="icon" type="image/png" href="assets/images/logo.png" />
</head>

<body>
  <?php require_once('preloader.php'); ?>
  <!--header-->
  <?php require_once('header.php'); ?>
  <!--/header-->
  <div class="inner-banner">
  </div>
  <section class="w3l-breadcrumb">
    <div class="container">
      <ul class="breadcrumbs-custom-path">
        <li><a href="/">Home</a></li>
        <li class="active"><span class="fa fa-angle-right mx-2" aria-hidden="true"></span> Insurance</li>
      </ul>
    </div>
  </section>
  <!-- home page about section -->
  <section class="w3l-index3" id="about">
    <div class="midd-w3 py-5">
      <div class="container py-lg-5 py-md-3">
        <div class="row">
          <div class="col-lg-6">
            <div class="position-relative">
              <img src="assets/images/blog10.jpg" alt="" class="radius-image img-fluid">
            </div>
          </div>
          <div class="col-lg-6 mt-lg-0 mt-md-5 mt-4 align-self">
            <?php require_once('translate.php'); ?>
            <h3 class="title-big mx-0">Peace of mind for you and your family</h3>
            <p class="mt-md-4 mt-3">
              As a <?= $main_name ?> Private customer, your Relationship Manager will work with you to provide insurance solutions that meet your needs. Whether you are looking for protection for your life and lifestyle, your home and contents or your car, we can help create a package that is both suitable, and flexible enough to change when your circumstances and goals do.
            </p>
          </div>
        </div>
      </div>
    </div>
  </section>
  <!-- //home page about section -->
  <!-- stats -->
  <section class="w3l-stats py-5" id="stats">
    <div class="gallery-inner container py-lg-5 py-md-4">
      <div class="row">
        <div class="col-lg-12 mt-lg-0 mt-md-5 mt-4 align-self">
          <p class="mt-md-4 mt-3 text-center">
            Superior home insurance
            <br>
            <?= $main_name ?> Private gives you access to a market leading home insurance service. This excellent service comes with home emergency cover as standard, complimentary 24-hour personal security support and advice on everything from safety abroad to identity theft.
          </p>
          <p class="mt-md-4 mt-3 text-center">
            <a href="contact"><b>Get a quote and apply online</b></a>
          </p>
          <p class="mt-md-4 mt-3 text-center">
            Car solutions
            <br>
            Your Relationship Manager can help connect you with comprehensive car insurance, motor legal protection and breakdown cover - including a 24-hour claim line, temporary hire car, and unlimited cover for standard fit in-car equipment. And take out a second policy and we may be able to match the no claims discount.
          </p>
        </div>
      </div>
    </div>
  </section>
  <!-- //stats -->
  <!-- footer -->
  <?php require_once('footer.php'); ?>
  <!-- //footer -->
  <!--  javascripts file here -->
  <script src="assets/js/jquery-3.3.1.min.js"></script>
  <script src="assets/js/theme-change.js"></script> <!-- //light and dark mode switch js -->
  <script src="assets/js/circles.js"></script>
  <!-- stats number counter-->
  <script src="assets/js/jquery.waypoints.min.js"></script>
  <script src="assets/js/jquery.countup.js"></script>
  <script>
    $('.counter').countUp();
  </script>
  <!-- //stats number counter -->
  <!-- owl carousel -->
  <script src="assets/js/owl.carousel.js"></script>
  <!-- script for banner slider-->
  <script>
    $(document).ready(function() {
      $('.owl-one').owlCarousel({
        loop: true,
        margin: 0,
        nav: false,
        responsiveClass: true,
        autoplay: true,
        autoplayTimeout: 5000,
        autoplaySpeed: 1000,
        autoplayHoverPause: false,
        responsive: {
          0: {
            items: 1
          },
          480: {
            items: 1
          },
          667: {
            items: 1
          },
          1000: {
            items: 1
          }
        }
      })
    })
  </script>
  <!-- //script -->
  <!-- owl carousel -->
  <!-- script for tesimonials carousel slider -->
  <script>
    $(document).ready(function() {
      $("#owl-demo2").owlCarousel({
        loop: true,
        margin: 20,
        nav: false,
        responsiveClass: true,
        responsive: {
          0: {
            items: 1,
            nav: false
          },
          1000: {
            items: 1,
            nav: false,
            loop: false
          }
        }
      })
    })
  </script>
  <!-- //script for tesimonials carousel slider -->
  <!-- disable body scroll which navbar is in active -->
  <script>
    $(function() {
      $('.navbar-toggler').click(function() {
        $('body').toggleClass('noscroll');
      })
    });
  </script>
  <!-- disable body scroll which navbar is in active -->
  <!--/MENU-JS-->
  <script>
    $(window).on("scroll", function() {
      var scroll = $(window).scrollTop();

      if (scroll >= 80) {
        $("#site-header").addClass("nav-fixed");
      } else {
        $("#site-header").removeClass("nav-fixed");
      }
    });

    //Main navigation Active Class Add Remove
    $(".navbar-toggler").on("click", function() {
      $("header").toggleClass("active");
    });
    $(document).on("ready", function() {
      if ($(window).width() > 991) {
        $("header").removeClass("active");
      }
      $(window).on("resize", function() {
        if ($(window).width() > 991) {
          $("header").removeClass("active");
        }
      });
    });
  </script>
  <!--//MENU-JS-->
  <script src="assets/js/bootstrap.min.js"></script><!-- //bootstrap js -->
  <?php include('chat.php'); ?>
</body>

</html>
