<?php require_once('setup.php'); ?>
<!doctype html>
<html lang="en">

<head>
  <!-- Required meta tags -->
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
  <title><?= $main_capital_name; ?></title>
  <link href="//fonts.googleapis.com/css2?family=Kumbh+Sans:wght@300;400;700&display=swap" rel="stylesheet">
  <!-- Template CSS -->
  <link rel="stylesheet" href="assets/css/style-starter.css">
  <link rel="icon" type="image/png" href="assets/images/logo.png" />
</head>

<body>
  <?php require_once('preloader.php'); ?>
  <!--header-->
  <?php require_once('header.php'); ?>
  <!--/header-->
  <div class="inner-banner">
  </div>
  <section class="w3l-breadcrumb">
    <div class="container">
      <ul class="breadcrumbs-custom-path">
        <li><a href="/">Home</a></li>
        <li class="active"><span class="fa fa-angle-right mx-2" aria-hidden="true"></span> Mortgages</li>
      </ul>
    </div>
  </section>
  <!-- home page about section -->
  <section class="w3l-index3" id="about">
    <div class="midd-w3 py-5">
      <div class="container py-lg-5 py-md-3">
        <div class="row">
          <div class="col-lg-6">
            <div class="position-relative">
              <img src="assets/images/blog4.jpg" alt="" class="radius-image img-fluid">
            </div>
          </div>
          <div class="col-lg-6 mt-lg-0 mt-md-5 mt-4 align-self">
            <?php require_once('translate.php'); ?>
            <h3 class="title-big mx-0">Mortgages</h3>
            <p class="mt-md-4 mt-3">
              The more you know, the easier it is
            </p>
            <p class="mt-md-4 mt-3">
              Owning a house is everyone’s dream, doing so through a hassle-free process is an icing on the cake. This is what <?= $main_name ?> stands to offer - making the dream of owing your own home a reality! Whether you are planning to buy a land and build later, or commence construction or buy an already developed home, we are there all the way as a trusted companion, guiding and supporting financially when others fail to.
            </p>
            <p class="mt-md-4 mt-3">
              Our well thought - out loan choices with peculiar features to suit your needs, aspirations and financial conditions is a must to experience.
            </p>
          </div>
        </div>
      </div>
    </div>
  </section>
  <!-- //home page about section -->
  <!-- stats -->
  <section class="w3l-stats py-5" id="stats">
    <div class="gallery-inner container py-lg-5 py-md-4">
      <div class="row">
        <div class="col-lg-6 mt-lg-0 mt-md-5 mt-4 align-self">
          <h3>What do i need to know?</h3>
          <ol>
            <li>- Steps to Property Ownership</li>
            <li>- What can I use the loan for?</li>
            <li>- What are the loan features?</li>
            <li>- How do I insure my property?</li>
            <li>- What document do I need to provide for the loan request?</li>
            <li>- What about Non Resident Mortgage Facility?</li>
          </ol>
        </div>
        <div class="col-lg-6 mt-lg-0 mt-md-5 mt-4 align-self">
          <h3>Available mortgages</h3>
          <ol>
            <li>- Developed Home Purchase</li>
            <li>- Land Acquisition</li>
            <li>- Home Construction</li>
            <li>- Home Renovation</li>
            <li>- Existing Mortgage Refinance</li>
            <li>- No charges for everyday transactions - just stay in credit.</li>
            <li>- Up to $25 interest and fee free Planned Overdraft.</li>
          </ol>
        </div>
      </div>
      <div class="row">
        <div class="col-lg-12 mt-lg-0 mt-md-5 mt-4 align-self">
          <h3>Benefits</h3>
          <ol>
            <li>- Interest rate is variable and benchmarked on Home & Savings stands Prime Lending Rate</li>
            <li>- Available for tenor of up to 20 years</li>
            <li>- Loan Amount up to 80% of property value subject to a maximum amount of $70m for Brussels property</li>
            <li>- Loan Amount up to 80% of property value subject to a maximum amount of $400,000.00 for for Brussels property</li>
            <li>- Freedom to repay loan in full without prepayment penalty</li>
            <li>- Monthly or structured pre-agreed repayments terms</li>
            <li>- Interest only repayment allowed up until completion, if property is under construction</li>
            <li>- Progressive drawdown against bank approved Quantity Surveyor’s certificate Reduced or no COT on linked account</li>
            <li>- Negotiable management fee... and more</li>
          </ol>
        </div>
      </div>
    </div>
  </section>
  <!-- //stats -->
  <!-- footer -->
  <?php require_once('footer.php'); ?>
  <!-- //footer -->
  <!--  javascripts file here -->
  <script src="assets/js/jquery-3.3.1.min.js"></script>
  <script src="assets/js/theme-change.js"></script> <!-- //light and dark mode switch js -->
  <script src="assets/js/circles.js"></script>
  <!-- stats number counter-->
  <script src="assets/js/jquery.waypoints.min.js"></script>
  <script src="assets/js/jquery.countup.js"></script>
  <script>
    $('.counter').countUp();
  </script>
  <!-- //stats number counter -->
  <!-- owl carousel -->
  <script src="assets/js/owl.carousel.js"></script>
  <!-- script for banner slider-->
  <script>
    $(document).ready(function() {
      $('.owl-one').owlCarousel({
        loop: true,
        margin: 0,
        nav: false,
        responsiveClass: true,
        autoplay: true,
        autoplayTimeout: 5000,
        autoplaySpeed: 1000,
        autoplayHoverPause: false,
        responsive: {
          0: {
            items: 1
          },
          480: {
            items: 1
          },
          667: {
            items: 1
          },
          1000: {
            items: 1
          }
        }
      })
    })
  </script>
  <!-- //script -->
  <!-- owl carousel -->
  <!-- script for tesimonials carousel slider -->
  <script>
    $(document).ready(function() {
      $("#owl-demo2").owlCarousel({
        loop: true,
        margin: 20,
        nav: false,
        responsiveClass: true,
        responsive: {
          0: {
            items: 1,
            nav: false
          },
          1000: {
            items: 1,
            nav: false,
            loop: false
          }
        }
      })
    })
  </script>
  <!-- //script for tesimonials carousel slider -->
  <!-- disable body scroll which navbar is in active -->
  <script>
    $(function() {
      $('.navbar-toggler').click(function() {
        $('body').toggleClass('noscroll');
      })
    });
  </script>
  <!-- disable body scroll which navbar is in active -->
  <!--/MENU-JS-->
  <script>
    $(window).on("scroll", function() {
      var scroll = $(window).scrollTop();

      if (scroll >= 80) {
        $("#site-header").addClass("nav-fixed");
      } else {
        $("#site-header").removeClass("nav-fixed");
      }
    });

    //Main navigation Active Class Add Remove
    $(".navbar-toggler").on("click", function() {
      $("header").toggleClass("active");
    });
    $(document).on("ready", function() {
      if ($(window).width() > 991) {
        $("header").removeClass("active");
      }
      $(window).on("resize", function() {
        if ($(window).width() > 991) {
          $("header").removeClass("active");
        }
      });
    });
  </script>
  <!--//MENU-JS-->
  <script src="assets/js/bootstrap.min.js"></script><!-- //bootstrap js -->
  <?php include('chat.php'); ?>
</body>

</html>
